// ==UserScript==
// @name         Force Save Scroll Position V2
// @namespace    http://tampermonkey.net/
// @version      2.0
// @description  שמירה אגרסיבית של מיקום הגלילה עם חיווי ויזואלי
// @author       Gemini
// @match        *://*/*
// @grant        none
// @run-at       document-start
// ==/UserScript==

(function() {
    'use strict';

    // הגדרות
    const CHECK_INTERVAL = 500; // כל כמה זמן לנסות לגלול (במילישניות)
    const MAX_ATTEMPTS = 10;    // כמה פעמים לנסות (סה"כ 5 שניות)
    const uniqueKey = 'scrollPos_v2_' + window.location.pathname; // שימוש ב-pathname כדי להיות ספציפי יותר

    // יצירת חיווי ויזואלי (נקודה בצד המסך)
    const indicator = document.createElement('div');
    indicator.style.cssText = 'position:fixed; bottom:10px; left:10px; width:10px; height:10px; border-radius:50%; background:red; z-index:99999; pointer-events:none; opacity:0.7;';
    
    // הוספת הנקודה רק כשהדף נטען
    window.addEventListener('DOMContentLoaded', () => {
        document.body.appendChild(indicator);
    });

    // ביטול השחזור האוטומטי של הדפדפן כדי למנוע התנגשות
    if ('scrollRestoration' in history) {
        history.scrollRestoration = 'manual';
    }

    // פונקציה לשחזור המיקום
    function restoreScroll() {
        const savedPos = localStorage.getItem(uniqueKey);
        
        if (savedPos && parseInt(savedPos) > 0) {
            const targetPos = parseInt(savedPos, 10);
            
            // מנסים לגלול
            window.scrollTo(0, targetPos);
            
            // בדיקה האם הצלחנו להגיע ליעד (פלוס מינוס 50 פיקסלים)
            if (Math.abs(window.scrollY - targetPos) < 50) {
                indicator.style.background = '#00ff00'; // ירוק - הצלחה
                return true; // הצלחנו, אפשר להפסיק לנסות
            }
        }
        return false;
    }

    // ניסיונות חוזרים לשחזור (למקרה שהדף כבד)
    let attempts = 0;
    const scrollInterval = setInterval(() => {
        const success = restoreScroll();
        attempts++;
        
        // אם הצלחנו או שעברנו את מכסת הניסיונות - עוצרים
        if (success || attempts >= MAX_ATTEMPTS) {
            clearInterval(scrollInterval);
        }
    }, CHECK_INTERVAL);

    // מנגנון שמירה
    let saveTimeout;
    window.addEventListener('scroll', function() {
        clearTimeout(saveTimeout);
        saveTimeout = setTimeout(function() {
            localStorage.setItem(uniqueKey, window.scrollY);
            // הבהוב צהוב לשמירה
            indicator.style.background = 'yellow';
            setTimeout(() => { indicator.style.background = '#00ff00'; }, 200);
        }, 200);
    }, { passive: true });

})();